<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="COCT_MT040200">
    <title>R_ResponsibleParty universal</title>
    <rule context="$element">
        <assert role="error" test="not(@classCode) or @classCode='ASSIGNED'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#ASSIGNED"
            >COCT_MT040200: @classCode moet indien aanwezig 'ASSIGNED' zijn</assert>
    </rule>
    <rule context="$element/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        agentOrganization or representedOrganization
    -->
    <title>E_Organization universal</title>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization'] | $element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:part/hl7:partOrganization | $element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:part-of/hl7:wholeOrganization">
        <assert role="error" test="not(@classCode) or @classCode='ORG'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#ORG"
            >COCT_MT040200/COCT_MT150000: @classCode moet indien aanwezig 'ORG' zijn</assert>
        <assert role="error" test="hl7:id[@root='2.16.528.1.1007.3.3']"
            >COCT_MT040200/COCT_MT150000: er moet tenminste een UZI-registerabonneenummer zijn ter identificatie</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.2.4.15.1060'"
            >COCT_MT040200/COCT_MT150000: organisatietype moet komen uit codesysteem '2.16.840.1.113883.2.4.15.1060'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:name">
        <extends rule="ON"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:standardIndustryClassCode">
        <extends rule="CE"/>
    </rule>
    
    <!-- 
        ContactParty
    -->
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact">
        <assert role="error" test="not(@classCode) or @classCode='CON'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#CON"
            >COCT_MT040200/COCT_MT150000: @classCode moet indien aanwezig 'CON' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    
    <!-- 
        ContactParty/Person 
    -->
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson">
        <assert role="error" test="not(@classCode) or @classCode='PSN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#PSN"
            >COCT_MT040200/COCT_MT150000: @classCode moet indien aanwezig 'PSN' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT040200/COCT_MT150000: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="EN"/>
    </rule>
    
    <!-- 
        ContactParty/Person/LocatedEntity
    -->
    <title>R_LocationLocatedEntity universal</title>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity">
        <assert role="error" test="not(@classCode) or @classCode='ASSIGNED'"
            >COCT_MT040200/COCT_MT150000/COCT_MT070000: @classCode moet indien aanwezig 'ASSIGNED' zijn</assert>
        
        <assert role="error" test="hl7:id or hl7:addr or hl7:telecom or hl7:location"
            >COCT_MT040200/COCT_MT150000/COCT_MT070000: one of id, addr, telecom or location must be non-null</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <title>E_Place universal</title>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place | $element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:scopedLocatedEntityHasParts/hl7:locatedPlace | $element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:playedLocatedEntityPartOf/hl7:location">
        <assert role="error" test="not(@classCode) or @classCode='PLC'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#PLC"
            >COCT_MT040200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @classCode moet indien aanwezig 'PLC' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT040200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSyem) or @codeSystem='2.16.840.1.113883.5.1060'" see="http://www.hl7.org/v3ballot8/html/foundationdocuments/referencefiles/EntityCode.htm"
            >COCT_MT040200/COCT_MT150000/COCT_MT070000/COCT_MT710000: plaatscode moet komen uit codesysteem '2.16.840.1.113883.5.1060'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:name">
        <extends rule="EN"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:directionsText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:positionText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:gpsText">
        <extends rule="ST"/>
    </rule>
    
    <!-- 
        ContactParty/Person/LocatedEntity/scopedLocatedEntityHasParts
    -->
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:scopedLocatedEntityHasParts">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#LOCE"
            >COCT_MT040200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:scopedLocatedEntityHasParts/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <!-- 
        ContactParty/Person/LocatedEntity/playedLocatedEntityPartOf
    -->
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:playedLocatedEntityPartOf">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#LOCE"
            >COCT_MT040200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentOrganization' or local-name()='representedOrganization']/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:playedLocatedEntityPartOf/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <!-- 
        agentPerson or representedPerson
    -->
    <title>E_Person universal</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']">
        <assert role="error" test="not(@classCode) or @classCode='PSN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#PSN"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'PSN' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT040200/COCT_MT030200: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
        <assert role="error" test="not(hl7:id) or count(hl7:id)=1"
            >COCT_MT040200/COCT_MT030200: er kan slechts 1 persoonsnummer zijn</assert>
        <assert role="error" test="count(hl7:name) &lt;=2"
            >COCT_MT040200/COCT_MT030200: er mogen niet meer dan 2 persoonsnamen zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
            >COCT_MT040200/COCT_MT030200: als er een persoonsnummer wordt gebruikt moet dat het burgerservicenummer zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:name">
        <extends rule="PN"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:administrativeGenderCode">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.5.1'"
            >COCT_MT040200/COCT_MT030200: geslacht moet komen uit codesysteem '2.16.840.1.113883.5.1'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:birthTime">
        <extends rule="TS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:deceasedInd">
        <extends rule="BL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:deceasedTime">
        <extends rule="TS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:multipleBirthInd">
        <extends rule="BL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:multipleBirthOrderNumber">
        <extends rule="INT"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:organDonorInd">
        <extends rule="BL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:maritalStatusCode">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.5.2'"
            >COCT_MT040200/COCT_MT030200: burgerlijke staat moet komen uit codesysteem '2.16.840.1.113883.5.2'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:educationLevelCode">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:disabilityCode">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:livingArrangementCode">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:religiousAffiliationCode">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:raceCode">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:ethnicGroupCode">
        <extends rule="CE"/>
    </rule>
    
    <title>scopedBirthPlace</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace">
        <assert role="error" test="not(@classCode) or @classCode='BIRTHPLC'"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'BIRTHPLC' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:addr">
        <extends rule="AD"/>
        <assert role="error" test="@nullFlavor or hl7:city or hl7:county or hl7:country"
            >COCT_MT040200/COCT_MT030200: geboorteplaats moet tenminste het element city (plaats), county (gemeente), of country (land) bevatten</assert>
    </rule>
    
    <title>E_Place universal</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:scopedLocatedEntityHasParts/hl7:locatedPlace | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:playedLocatedEntityPartOf/hl7:location">
        <assert role="error" test="not(@classCode) or @classCode='PLC'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT710000: @classCode moet indien aanwezig 'PLC' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT710000: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSyem) or @codeSystem='2.16.840.1.113883.5.1060'" see="http://www.hl7.org/v3ballot8/html/foundationdocuments/referencefiles/EntityCode.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT710000: plaatscode moet komen uit codesysteem '2.16.840.1.113883.5.1060'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:name">
        <extends rule="EN"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:directionsText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:positionText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:gpsText">
        <extends rule="ST"/>
    </rule>
    
    <!-- 
        scopedLocatedEntityHasParts
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:scopedLocatedEntityHasParts">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT710000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedLocatedEntityHasParts/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <!-- 
        playedLocatedEntityPartOf
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:playedLocatedEntityPartOf">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT710000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:scopedBirthPlace/hl7:birthPlace/hl7:playedLocatedEntityPartOf/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <!-- 
        citizenship
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:citizenship">
        <assert role="error" test="not(@classCode) or @classCode='CIT'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#CIT"
            >COCT_MT040200/COCT_MT030200/COCT_MT710000: @classCode moet indien aanwezig 'CIT' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:citizenship/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:citizenship/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        citizenship/politicalOrganization, employment/employerOrganization, schoolEnrollment/schoolOrganization, playedOtherIDs/scopingOrganization
    -->
    <title>E_Organization universal</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:* | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part/hl7:partOrganization | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part-of/hl7:wholeOrganization">
        <assert role="error" test="not(@classCode) or @classCode='ORG'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#ORG"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: @classCode moet indien aanwezig 'ORG' zijn</assert>
        <assert role="error" test="hl7:id[@root='2.16.528.1.1007.3.3']"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: er moet tenminste een UZI-registerabonneenummer zijn ter identificatie</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.2.4.15.1060'"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: organisatietype moet komen uit codesysteem '2.16.840.1.113883.2.4.15.1060'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:name">
        <extends rule="ON"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:standardIndustryClassCode">
        <extends rule="CE"/>
    </rule>
    
    <!-- 
        ContactParty
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact">
        <assert role="error" test="not(@classCode) or @classCode='CON'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#CON"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: @classCode moet indien aanwezig 'CON' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    
    <!-- 
        ContactParty/Person 
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson">
        <assert role="error" test="not(@classCode) or @classCode='PSN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#PSN"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: @classCode moet indien aanwezig 'PSN' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="EN"/>
    </rule>
    
    <!-- 
        ContactParty/Person/LocatedEntity
    -->
    <title>R_LocationLocatedEntity universal</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity">
        <assert role="error" test="not(@classCode) or @classCode='ASSIGNED'"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000/COCT_MT070000: @classCode moet indien aanwezig 'ASSIGNED' zijn</assert>
        
        <assert role="error" test="hl7:id or hl7:addr or hl7:telecom or hl7:location"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000/COCT_MT070000: one of id, addr, telecom or location must be non-null</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <title>E_Place universal</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:scopedLocatedEntityHasParts/hl7:locatedPlace | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:playedLocatedEntityPartOf/hl7:location">
        <assert role="error" test="not(@classCode) or @classCode='PLC'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#PLC"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @classCode moet indien aanwezig 'PLC' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSyem) or @codeSystem='2.16.840.1.113883.5.1060'" see="http://www.hl7.org/v3ballot8/html/foundationdocuments/referencefiles/EntityCode.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000/COCT_MT070000/COCT_MT710000: plaatscode moet komen uit codesysteem '2.16.840.1.113883.5.1060'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:name">
        <extends rule="EN"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:directionsText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:positionText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:gpsText">
        <extends rule="ST"/>
    </rule>
    
    <!-- 
        ContactParty/Person/LocatedEntity/scopedLocatedEntityHasParts
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:scopedLocatedEntityHasParts">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#LOCE"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:scopedLocatedEntityHasParts/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <!-- 
        ContactParty/Person/LocatedEntity/playedLocatedEntityPartOf
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:playedLocatedEntityPartOf">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#LOCE"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000/COCT_MT070000/COCT_MT710000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:contact/hl7:contactPerson/hl7:LocatedEntity/hl7:Place/hl7:playedLocatedEntityPartOf/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <!-- 
        part
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        part-of
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part-of">
        <assert role="error" test="not(@classCode) or @classCode='LOCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm"
            >COCT_MT040200/COCT_MT030200/COCT_MT150000: @classCode moet indien aanwezig 'LOCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part-of/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part-of/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='citizenship' or local-name()='employment' or local-name()='schoolEnrollment' or local-name()='playedOtherIDs']/hl7:*/hl7:part-of/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        employment
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment">
        <assert role="error" test="not(@classCode) or @classCode='EMP'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#EMP"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'EMP' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:jobCode">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:jobTitleName">
        <extends rule="SC"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:employment/hl7:jobClassCode">
        <extends rule="CE"/>
    </rule>
    
    <!-- 
        guarantor 
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guarantor">
        <assert role="error" test="not(@classCode) or @classCode='GUAR'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#GUAR"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'GUAR' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guarantor/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guarantor/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guarantor/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guarantor/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        guarantor/guarantorEntityChoice/Person or guardian/guardianEntityChoice/Person or contact/contactEntityChoice/Person
    -->
    <title>CMET E_Person identified/confirmable</title>
    <title>E_PersonNL identified/confirmable</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person">
        <assert role="error" test="not(@classCode) or @classCode='PSN'"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: @classCode moet indien aanwezig 'PSN' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
        <assert role="error" test="not(hl7:id) or count(hl7:id)=1"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: er kan slechts 1 persoonsnummer zijn</assert>
        <assert role="error" test="count(hl7:name) &lt;=2"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: er mogen niet meer dan 2 persoonsnamen zijn</assert>
        
        <assert role="error" test="hl7:name or hl7:administrativeGenderCode or hl7:birthTime or hl7:birthPlace"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: one of name, administrativeGenderCode, birthTime or birthPlace must be non-null</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: als er een persoonsnummer wordt gebruikt moet dat het burgerservicenummer zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:name">
        <extends rule="PN"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:administrativeGenderCode">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.5.1'"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: geslacht moet komen uit codesysteem '2.16.840.1.113883.5.1'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthTime">
        <extends rule="TS"/>
    </rule>
    
    <title>birthPlace</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthPlace">
        <assert role="error" test="not(@classCode) or @classCode='BIRTHPLC'"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: @classCode moet indien aanwezig 'BIRTHPLC' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthPlace/hl7:name">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthPlace/hl7:addr">
        <extends rule="AD"/>
        <assert role="error" test="@nullFlavor or hl7:city or hl7:county or hl7:country"
            >COCT_MT040200/COCT_MT030200/COCT_MT030202: geboorteplaats moet tenminste het element city (plaats), county (gemeente), of country (land) bevatten</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthPlace/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthPlace/hl7:directionsText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthPlace/hl7:positionText">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Person/hl7:birthPlace/hl7:gpsText">
        <extends rule="ST"/>
    </rule>
    
    <!-- 
        guarantor/guarantorEntityChoice/Person or guardian/guardianEntityChoice/Person or contact/contactEntityChoice/Person
    -->
    <title>E_Organization identified/confirmable</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Organization | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Organization/hl7:part/hl7:partOrganization | $element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Organization/hl7:part-of/hl7:wholeOrganization">
        <assert role="error" test="not(@classCode) or @classCode='ORG'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#ORG"
            >COCT_MT150002: @classCode moet indien aanwezig 'ORG' zijn</assert>
        <assert role="error" test="hl7:id[@root='2.16.528.1.1007.3.3']"
            >COCT_MT150002: er moet tenminste een UZI-registerabonneenummer zijn ter identificatie</assert>
        
        <assert role="error" test="hl7:id or hl7:name"
            >COCT_MT150002: id or addr must be non-null</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Organization/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Organization/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="not(@codeSystem) or @codeSystem='2.16.840.1.113883.2.4.15.1060'"
            >COCT_MT150002: organisatietype moet komen uit codesysteem '2.16.840.1.113883.2.4.15.1060'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Organization/hl7:name">
        <extends rule="ON"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:*[local-name()='guarantor' or local-name()='guardian' or local-name()='contact']/hl7:*/hl7:Organization/hl7:addr">
        <extends rule="AD"/>
    </rule>
    
    <!-- 
        guardian 
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian">
        <assert role="error" test="not(@classCode) or @classCode='GUARD'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#GUARD"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'GUARD' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:guardian/hl7:certificateText">
        <extends rule="ED"/>
    </rule>
    
    <!-- 
        memberOf 
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf">
        <assert role="error" test="not(@classCode) or @classCode='MBR'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#MBR"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'MBR' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        memberOf/groupEntity
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:groupEntity">
        <assert role="error" test="not(@classCode) or @classCode='ENT'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityClass.htm#ENT"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'ENT' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/EntityDeterminer.htm#INSTANCE"
            >COCT_MT040200/COCT_MT030200: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:groupEntity/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:groupEntity/hl7:quantity">
        <extends rule="INT"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:groupEntity/hl7:name">
        <extends rule="EN"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:groupEntity/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:groupEntity/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:memberOf/hl7:groupEntity/hl7:existenceTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        memberOf 
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:playedOtherIDs">
        <assert role="error" test="not(@classCode) or @classCode='ROL'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#ROL"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'ROL' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:playedOtherIDs/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <!--
        playedRole
    -->
    <title>CoveredParty COCT_MT500000</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:playedRole">
        <report role="warning" test="1=1">COCT_MT040200/COCT_MT030200/COCT_MT500000: deze controle moet nog worden gebouwd....</report>
    </rule>
    
    <!-- 
        schoolEnrollment 
    -->
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:schoolEnrollment">
        <assert role="error" test="not(@classCode) or @classCode='STD'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#STD"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'STD' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:schoolEnrollment/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:schoolEnrollment/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:schoolEnrollment/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:schoolEnrollment/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <!-- 
        languageCommunication
    -->
    <title>languageCommunication</title>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:languageCommunication">
        <assert role="error" test="not(@classCode) or @classCode='ROL'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#ROL"
            >COCT_MT040200/COCT_MT030200: @classCode moet indien aanwezig 'ROL' zijn</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:languageCommunication/hl7:languageCode">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.6.121'"
            >COCT_MT040200/COCT_MT030200: Taalcode moet komen uit codesysteem '2.16.840.1.113883.6.121'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:languageCommunication/hl7:modeCode">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.5.60'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/LanguageAbilityMode.htm"
            >COCT_MT040200/COCT_MT030200: Taalexpressiewijzecode moet komen uit codesysteem '2.16.840.1.113883.5.60'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.5.61'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/LanguageAbilityProficiency.htm"
            >COCT_MT040200/COCT_MT030200: Taalbeheersingscode moet komen uit codesysteem '2.16.840.1.113883.5.61'</assert>
    </rule>
    <rule context="$element/hl7:*[local-name()='agentPerson' or local-name()='representedPerson']/hl7:languageCommunication/hl7:preferenceInd">
        <extends rule="BL"/>
    </rule>
</pattern>